
import { showRentalArticleInfo } from '../../lib/RentalHelper.js';


loadCss('/static/app/widget/sales/css/rental-occupation.css');


export class RentalDailyView {


	tpl = `
		<table class="rental-weekly-view tbl-rentals">
			<thead>
				<tr class="day-list">
					<td></td>
					<td ez-forme="days" ez-item="d" colspan="{{hourCount}}" class="{{d.date == today ? 'td-today' : '' }}">
						{{ _('daynoshort.'+d.date_obj.getDay()) }}
						{{ d.date_obj.getDate() }}
						{{ _lc('monthshort.'+(d.date_obj.getMonth()+1)) }}
						{{ d.date_obj.getFullYear() }} 
					</td>
				</tr>
				<tr class="hour-list">
					<td></td>
					<td ez-forme="hours" ez-item="h">
						{{ h.hour }}
					</td>
				</tr>
			</thead>
			<tbody id="tbody-rental-articles">
			</tbody>
		</table>
	`;
	
	
	daysToShow = 1;
	
	container = null;
	
	ezTpl = null;
	
	days = null;
	hours = null;
	hourCount = null;
	
	lastSearchResult = null;
	
	
	
	init(e) {
		this.container = e;
		
	}
	
	
	getStart() {
		let d = document.querySelector('.container-settings input[name=d]').value;
		
		let date = str2date( d );
		
		return format_date(date);
	}
	
	getEnd() {
		let s = this.getStart();
		
		s = next_day( s, this.daysToShow );
		
		return s;
	}
	
	
	colHours() {
		let s = this.getStart();
		
		this.hours = [];
		this.days = [];
		
		let startHour = this.startHour();
		let endHour = this.endHour();
		
		this.hourCount = (endHour - startHour)+1;
		
		for(let i=0; i < this.daysToShow; i++) {
			
			// push day
			this.days.push({
				date: s,
				date_obj: str2date(s)
			});
			
			// push hours for day
			for(let j=startHour; j <= endHour; j++) {
				this.hours.push({
					hour: j,
					date: s,
					ymdDate: date2ymd( s )
				});
			}
			
			s = next_day( s, 1 );
		}
	}
	
	startHour() {
		let t = this.salesSettings.rentalDailyStartTime;
		let toks = t.split(':');
		return parseInt(toks[0]);
	}
	endHour() {
		let t = this.salesSettings.rentalDailyEndTime;
		let toks = t.split(':');
		return parseInt(toks[0]);
	}
	
	
	renderSearch( searchResult ) {
//		document.querySelector('#tbody-rental-articles').innerHTML = '';
		
		this.salesSettings = searchResult.salesSettings;
		
		this.colHours();
		
		this.render();
		
		this.lastSearchResult = searchResult;
		
		
		let articles = searchResult.articles;
		
		for(let i=0; i < articles.length; i++) {
			let art = articles[i];
			this.addArticle( art );
		}
	}
	
	
	addArticle( art ) {
		// row
		let tr = document.createElement('tr');
		tr.className = 'article-line';
		
		// label
		let td_desc = document.createElement('td');
		td_desc.className = 'article-description';
		td_desc.innerText = art.shortDescription;
		tr.appendChild( td_desc );
		
		// convert dates to ymd
		let dates = [];
		for(let i=0; i < art.rentalContractLines.length; i++) {
			let rcl = art.rentalContractLines[i];
			
			let ymdStart = date2ymd( rcl.startTime );
			let ymdEnd  = rcl.endTime ? date2ymd( rcl.endTime ) : null;
			
			dates.push({ ymdStart: ymdStart, ymdEnd: ymdEnd, rentalContractLine: rcl });
		}
		
		
		// generate TD's for days
		for(let i=0; i < this.hours.length; i++) {
			let hour = this.hours[i];
			
			let rentalContractLine = null;
			for(let i in dates) {
				if ( hour.ymdDate >= dates[i].ymdStart && ( dates[i].ymdEnd == null || dates[i].ymdEnd >= hour.ymdDate ) ) {
					rentalContractLine = dates[i].rentalContractLine;
				}
			}
			
			
			let td = document.createElement('td');
			
			if (rentalContractLine) {
				td.className = 'occupied';
			}
			else {
				td.className = 'open';
			}
			let sp = document.createElement('span');
			sp.innerHTML = '&nbsp;';
			sp.onclick = () => {
				this.showRentalInfo( art.articleId, {date: hour.date, rentalContractId: rentalContractLine} );
			};
			td.appendChild(sp);
			
			tr.append( td );
		}
		
		
		
		
		let tbody = document.querySelector('#tbody-rental-articles');
		tbody.appendChild( tr );
	}
	
	

	
	showRentalInfo( articleId, opts ) {
		
		showRentalArticleInfo( articleId, opts );
	}
	
	
	render() {
//		this.colDates();
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('days', this.days);
		this.ezTpl.setVar('hours', this.hours);
		this.ezTpl.setVar('hourCount', this.hourCount);
		this.ezTpl.setVar('today', format_date(new Date()));
		
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
		
		
	}
		

	
	
}


